from vcCommand import *
from vcHelpers.Selection import *

REPORT_PROPERTY_LABEL = "Component Property Report" # <-- 1. DEFINE LABEL HERE
LAST_INTERVAL_NAME = app.getLocalizedString("ComboKey::Python.__ComponentPartsAverageCountReport__.DataFrom.Last Interval")

###
REPORT_PROPERTY_NAMES = ["MyProperty1", "MyProperty2"] # <-- 2. ADD COMPONENT PROPERTY NAMES HERE IN THIS LIST
### FOR EXAMPLE:
### REPORT_PROPERTY_NAMES = ["MyProperty1", "MyProperty2"]
### => THE FIRST PROPERTY FOUND IS USED FOR EACH COMPONENT.
###

app = getApplication()
cmd = getCommand()


def sort_components_by_names(comps):
  new_comps = []
  unique_names = []
  for comp in comps:
    if ' #' in comp.Name:
      name = comp.Name.split(' #')[0]
    else:
      name = comp.Name
    if name not in unique_names:
      unique_names.append(name)
  unique_names.sort()
  for unique_name in unique_names:
    iterable_comps = []
    for i,x in enumerate(comps):
      if ' #' in x.Name:
        if unique_name == x.Name.split(' #')[0]:
          iterable_comps.append(x)
      elif unique_name == x.Name:
          new_comps.append(x)
    iterable_comps = sorted(iterable_comps, key = lambda x : int(x.Name.split("#")[1]))
    for c in iterable_comps:
      new_comps.append(c)
  return new_comps


def first_state():
  global comps, chart
  selection = app.SelectionManager
  comps = selection.getSelection(VC_SELECTION_COMPONENT)
  if len(comps) == 0:
    title = app.getLocalizedString("ComboKey::Python.StatisticsMsgBoxTitle.Text")
    message = app.getLocalizedString("ComboKey::Python.StatisticsMsgBoxMessageNoComponents.Text")
    app.messageBox(message,title, 2, 1)  
    return  
  if REPORT_PROPERTY_NAMES:
    comps = sort_components_by_names([x for x in comps if any([x.getProperty(prop_name) for prop_name in REPORT_PROPERTY_NAMES])])
    if len(comps) == 0:
      title = app.getLocalizedString("ComboKey::Python.StatisticsMsgBoxTitle.Text")
      message = app.getLocalizedString("ComboKey::Python.StatisticsMsgBoxMessageNoProperties.Text") + " {}".format(REPORT_PROPERTY_NAMES)
      app.messageBox(message,title, 2, 1) 
      return

  dash = app.Dashboard

  # Detect what dashboard tab is selected and if no tabs ia available create one
  tab = dash.SelectedTab
  if tab == None:
    tab = dash.createTab('New', True)

  # Detect what chart location in the dashboard tab is selected for chart creation
  selChart = tab.SelectedChart
  if selChart == None:
    title = app.getLocalizedString("ComboKey::Python.StatisticsMsgBoxTitle.Text")
    message = app.getLocalizedString("ComboKey::Python.StatisticsMsgBoxMessageNoChartLocation.Text")
    app.messageBox(message,title, 2, 1) 
    return
  chart = tab.createChart(selChart, VC_CHARTTYPE_LINE, False)
  chart.TitleVisibility = True
  chart.LegendVisibility = True

  if len(REPORT_PROPERTY_NAMES) > 0:

    if len(comps) > 1:
      chart.Name = REPORT_PROPERTY_LABEL
    else:
      chart.Name = comps[0].Name + ": " + REPORT_PROPERTY_LABEL

    for comp in comps:
      s = chart.addSeries()
      s.Name = comp.Name
      for prop_name in REPORT_PROPERTY_NAMES:
        prop = comp.getProperty(prop_name)
        if prop:
          break
      s.Property = prop


addState(first_state)