from vcCommand import *
from vcHelpers.Selection import *

REPORT_PROPERTY_LABEL = "Statistics Property Report" # <-- 1. DEFINE LABEL HERE
LAST_INTERVAL_NAME = app.getLocalizedString("ComboKey::Python.__ComponentPartsAverageCountReport__.DataFrom.Last Interval")

###
REPORT_STATISTICS_PROPERTY_NAMES = ["PartsIntervalEntered", "PartsEntered"] # <-- 2. DEFINE STATISTICS BEHAVIOR PROPERTIES HERE IN THIS LIST
### FOR EXAMPLE:
### REPORT_STATISTICS_PROPERTY_NAMES = ["PartsIntervalEntered", "PartsEntered"]
### => FIRST INTERVAL TYPE AND THEN THE ONE OF THE WHOLE SIMULATION. 
###

app = getApplication()
cmd = getCommand()


def close_panel():
  reset_cmd = app.findCommand('resetSimulation')
  reset_cmd.execute()
  save_state_cmd = app.findCommand('saveState')
  save_state_cmd.execute()  


def update_chart(arg=None):
  global comps, chart, data_prop, finalized  
  if not finalized:
    return
  if not chart.ChartType:
    close_panel()
    return  
  chart.clearSeries()
  # Define the name of the chart 
  if len(comps) == 1:
    comp_name = comps[0].Name + ' - '
  else: 
    comp_name = ''
  if data_prop.Value == data_prop.StepValues[0]: # Last Interval
    chart.Name = "{}{} ({})".format(comp_name,REPORT_PROPERTY_LABEL,LAST_INTERVAL_NAME)
    prop_name = REPORT_STATISTICS_PROPERTY_NAMES[0]
  else:
    chart.Name = "{}{}".format(comp_name,REPORT_PROPERTY_LABEL)
    prop_name = REPORT_STATISTICS_PROPERTY_NAMES[1]
  # Define the data series and their colors
  for comp in comps:
    stats = comp.findBehavioursByType(VC_STATISTICS)
    statistics = stats[0]
    s = chart.addSeries()
    s.Name = comp.Name
    s.Property = statistics.getProperty(prop_name)


def configure_action_panel_UI():
  global data_prop, finalized
  finalized = False
  for prop in cmd.Properties:
    cmd.deleteProperty(prop)

  data_prop = cmd.createProperty(VC_STRING,'DataFrom', VC_PROPERTY_STEP)
  data_prop.StepValues = ['Last Interval','Simulation Run']
  data_prop.Value = data_prop.StepValues[0]
  data_prop.OnChanged = update_chart
  
  executeInActionPanel()
  finalized = True
  update_chart()


def sort_components_by_names(comps):
  new_comps = []
  unique_names = []
  for comp in comps:
    if ' #' in comp.Name:
      name = comp.Name.split(' #')[0]
    else:
      name = comp.Name
    if name not in unique_names:
      unique_names.append(name)
  unique_names.sort()
  for unique_name in unique_names:
    iterable_comps = []
    for i,x in enumerate(comps):
      if ' #' in x.Name:
        if unique_name == x.Name.split(' #')[0]:
          iterable_comps.append(x)
      elif unique_name == x.Name:
          new_comps.append(x)
    iterable_comps = sorted(iterable_comps, key = lambda x : int(x.Name.split("#")[1]))
    for c in iterable_comps:
      new_comps.append(c)
  return new_comps


def first_state():
  global comps, chart
  selection = app.SelectionManager
  comps = selection.getSelection(VC_SELECTION_COMPONENT)
  if len(comps) == 0:
    title = app.getLocalizedString("ComboKey::Python.StatisticsMsgBoxTitle.Text")
    message = app.getLocalizedString("ComboKey::Python.StatisticsMsgBoxMessageNoComponents.Text")
    app.messageBox(message,title, 2, 1)  
    return  

  comps = sort_components_by_names([x for x in comps if x.findBehavioursByType(VC_STATISTICS)])
  if len(comps) == 0:
    title = app.getLocalizedString("ComboKey::Python.StatisticsMsgBoxTitle.Text")
    message = app.getLocalizedString("ComboKey::Python.StatisticsMsgBoxMessageNoStatistics.Text")
    app.messageBox(message,title, 2, 1) 
    return
  dash = app.Dashboard

  # Detect what dashboard tab is selected and if no tabs ia available create one
  tab = dash.SelectedTab
  if tab == None:
    tab = dash.createTab('New', True)

  # Detect what chart location in the dashboard tab is selected for chart creation
  selChart = tab.SelectedChart
  if selChart == None:
    title = app.getLocalizedString("ComboKey::Python.StatisticsMsgBoxTitle.Text")
    message = app.getLocalizedString("ComboKey::Python.StatisticsMsgBoxMessageNoChartLocation.Text")
    app.messageBox(message,title, 2, 1) 
    return
  chart = tab.createChart(selChart, VC_CHARTTYPE_LINE, False)
  chart.TitleVisibility = True
  chart.LegendVisibility = True

  configure_action_panel_UI()


addState(first_state)