def getAllStatementsInRoutine(scope, statements=None):
  if not statements:
    statements = []
    
  for statement in scope.Statements:
    statements.append(statement)
    
    if statement.Scopes:
      for scope in statement.Scopes:
        getAllStatementsInRoutine(scope, statements)
        
  return statements
 
def getAllStatementsInRobotProgram(program):
  statements = getAllStatementsInRoutine(program.MainRoutine)
  
  for statement in statements:
    subroutine = statement.getProperty("Routine")
    if subroutine:
      getAllStatementsInRoutine(subroutine.Value, statements)
      
  return statements
  
#print len(getAllStatementsInRoutine(mainRoutine))

'''
positions = []
for statement in subroutines[0].Statements:
  try:
    print statement.Positions
  except:
    continue
'''

def getAllPositionsInRoutine(scope):
  statements = getAllStatementsInRoutine(scope)
  
  positions = []
  for statement in statements:
    try:
      for position in statement.Positions:
        positions.append(position)
    except:
      pass
        
  return positions
  
#print getAllPositionsInRoutine(mainRoutine)

def getAllPositionsInRobotProgram(program):
  positions = []
  positions = getAllPositionsInRoutine(program.MainRoutine)
  
  for subroutine in program.Routines:
    positionsInSubroutine = getAllPositionsInRoutine(subroutine)
    
    for position in positionsInSubroutine:
      positions.append(position)
      
  return positions 

#print len(getAllStatementsInRobotProgram(robotProgram))