from vcCommand import *

app = getApplication()


def first_state():
  global node, materials
  global preset_prop, material1_prop, material2_prop, material3_prop, material4_prop, material5_prop 
  global limit1_prop, limit2_prop, limit3_prop, limit4_prop
  global apply_prop, reset_prop, del_prop1, del_prop2, del_prop3, del_prop4, del_prop5, decimateprop, frozenmaterialsprop

  materials = dict( [(x.Name, x) for x in app.Materials] )

  preset_prop = createProperty(VC_STRING, 'Preset', VC_PROPERTY_STEP)
  preset_prop.StepValues = ['Reveal Small', 'Grayscale']
  preset_prop.Value = 'Reveal Small'
  preset_prop.OnChanged = set_preset

  material1_prop = createProperty('Ref<Material>','Material 1')
  material1_prop.Value = materials['red']
  material1_prop.IsVisible = True

  limit1_prop = createProperty(VC_STRING,'Size Limit 1')
  limit1_prop.Value = '100'
  limit1_prop.IsVisible = True

  material2_prop = createProperty('Ref<Material>','Material 2')
  material2_prop.Value = materials['glass1']
  material2_prop.IsVisible = True

  limit2_prop = createProperty(VC_STRING,'Size Limit 2')
  limit2_prop.Value = '200'
  limit2_prop.IsVisible = True

  material3_prop = createProperty('Ref<Material>','Material 3')
  material3_prop.Value = materials['glass1']
  material3_prop.IsVisible = True

  limit3_prop = createProperty(VC_STRING,'Size Limit 3')
  limit3_prop.Value = '500'
  limit3_prop.IsVisible = True

  material4_prop = createProperty('Ref<Material>','Material 4')
  material4_prop.Value = materials['glass1']
  material4_prop.IsVisible = True

  limit4_prop = createProperty(VC_STRING,'Size Limit 4')
  limit4_prop.Value = '1000'
  limit4_prop.IsVisible = True

  material5_prop = createProperty('Ref<Material>','Material 5')
  material5_prop.Value = materials['glass1']
  material5_prop.IsVisible = True

  apply_prop = createProperty(VC_BUTTON,'Apply')
  apply_prop.IsVisible = True
  apply_prop.OnChanged = call_them_materials

  reset_prop = createProperty(VC_BUTTON,'Reset Materials')
  reset_prop.IsVisible = True
  reset_prop.OnChanged = reset_them_materials

  del_prop1 = createProperty(VC_BUTTON,'Delete level 1')
  del_prop1.IsVisible = True
  del_prop1.OnChanged = delete_them_materials

  del_prop2 = createProperty(VC_BUTTON,'Delete level 2')
  del_prop2.IsVisible = True
  del_prop2.OnChanged = delete_them_materials

  del_prop3 = createProperty(VC_BUTTON,'Delete level 3')
  del_prop3.IsVisible = True
  del_prop3.OnChanged = delete_them_materials

  del_prop4 = createProperty(VC_BUTTON,'Delete level 4')
  del_prop4.IsVisible = True
  del_prop4.OnChanged = delete_them_materials

  del_prop5 = createProperty(VC_BUTTON,'Delete level 5')
  del_prop5.IsVisible = True
  del_prop5.OnChanged = delete_them_materials

  frozenmaterialsprop = createProperty(VC_STRING,'Frozen Materials')
  frozenmaterialsprop.Value = ''

  decimateprop = createProperty(VC_REAL,'DecimateFactor')
  decimateprop.Value = -1

  executeInActionPanel()


def set_preset(arg):
  if arg.Value == 'Reveal Small':
    material1_prop.Value = app.findMaterial('red')
    material2_prop.Value = app.findMaterial('glass1')
    material3_prop.Value = app.findMaterial('glass1')
    material4_prop.Value = app.findMaterial('glass1')
    material5_prop.Value = app.findMaterial('glass1')
  else:
    material1_prop.Value = app.findMaterial('chrome')
    material2_prop.Value = app.findMaterial('black')
    material3_prop.Value = app.findMaterial('dark_grey')
    material4_prop.Value = app.findMaterial('metal')
    material5_prop.Value = app.findMaterial('aluminium')

def reset_them_materials(arg):
  dematerialize() 

def call_them_materials(arg):
  materialize()   

def get_active_node():
  context = app.CurrentContext
  if context.Id != VC_CONTEXT_AUTHOR:
    'This command can be called from modeling context only'
    return
  node = context.ActiveNode
  if not node:
    print 'Auto Materialize addon error: Please select 1 Node and 1 Node only.'
    return
  return node

def delete_them_materials(arg):
  node = get_active_node()
  if not node: return
  if '1' in arg.Name: level = '1'
  elif '2' in arg.Name: level = '2'
  elif '3' in arg.Name: level = '3'
  elif '4' in arg.Name: level = '4'
  elif '5' in arg.Name: level = '5'
  materialProp = getProperty('Material %s' % level)
  root = node.RootFeature
  feas = root.Children
  # traverse the feature tree and delete geo sets by material
  while feas:
    fea = feas.pop(0)
    if fea.Type == VC_GEOMETRY:
      for g in fea.Geometry.GeometrySets:
        if g.Material and materialProp.Value and g.Material.Name == materialProp.Value.Name:
          fea.Geometry.deleteGeometrySet( g )
    feas.extend(fea.Children)
  node.rebuild()
  app.render()

def dematerialize():
  node = get_active_node()
  if not node: return
  root = node.RootFeature
  feas = root.Children
  a = 0
  # traverse the feature tree and find hidden geometry features
  while feas:
    fea = feas.pop(0)
    if fea.Type == VC_GEOMETRY:
      for g in fea.Geometry.GeometrySets:
        if 'MaTeRiaL' in g.Name:
          mat_name_list = g.Name.split('MaTeRiaL')
          name, matname = mat_name_list[0:2]
          matrl = app.findMaterial(matname)
          g.Material = matrl
          g.Name = name
    feas.extend(fea.Children)
  node.rebuild()
  app.render()


def materialize():
  node = get_active_node()
  if not node: return
  node.MaterialInheritance = VC_MATERIAL_DISABLED
  root = node.RootFeature
  feas = root.Children
  a = 0
  # traverse the feature tree and find suitable sized geometries
  while feas:
    fea = feas.pop(0) 
    if fea.Type == VC_GEOMETRY:
      for g in fea.Geometry.GeometrySets:
        if compare_size(limit1_prop, g):
          setMaterial( g, material1_prop.Value )
          if decimateprop.Value >= 0:
            g.decimate(decimateprop.Value, 5 )
        elif compare_size(limit2_prop, g):
          setMaterial( g, material2_prop.Value )
        elif compare_size(limit3_prop, g):
          setMaterial( g, material3_prop.Value )
        elif compare_size(limit4_prop, g):
          setMaterial( g, material4_prop.Value )
        else:
          setMaterial( g, material5_prop.Value )
    feas.extend(fea.Children)
  node.rebuild()
  app.render()


def compare_size(limit_prop, g_set):
  ref_sizes = [float(x) for x in limit_prop.Value.split(',')]
  x = g_set.BoundDiagonal.X*2
  y = g_set.BoundDiagonal.Y*2
  z = g_set.BoundDiagonal.Z*2
  if len(ref_sizes) == 1:
    ref_size = ref_sizes[0]
    size = (x**2 + y**2 + z**2) ** 0.5
    return size < ref_size
  elif len(ref_sizes) == 3:
    ref_sizes.sort()
    compare_sizes = [x,y,z]
    compare_sizes.sort()
    return all( [ x<y for x,y in zip(compare_sizes,ref_sizes) ] )
  else:
    print 'Check the value for %s: the value must be three comma-separeted values or a single numeric value' % limit_prop.Name


def setMaterial(g, material):
  '''
  "MaTeRiaL" is used as a marker and delimiter in the geoset name that 
  the geoset material has been edited. The original material name is stored in the geoset name
  '''
  frozenmaterials = getProperty('Frozen Materials').Value
  frozenmaterials = [x.strip() for x in frozenmaterials.split(',')]
  if g.Material and g.Material.Name in frozenmaterials:
    return
  if not 'MaTeRiaL' in g.Name:
    if g.Material:
      matName = g.Material.Name
    else:
      matName = 'NONENONE'
  else:
    matName = 'NONENONE'
  g.Name = g.Name + 'MaTeRiaL' + matName
  if material:
    mm = app.findMaterial(material.Name)
  else:
    mm = None
  g.Material = mm


def panel_closed():
  pass

panel = app.PythonActionPanel
panel.OnPanelClosed = panel_closed

addState( first_state )
